% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latte-optim.R
\name{latte-optim}
\alias{latte-optim}
\alias{latte_optim}
\alias{latte_max}
\alias{latte_min}
\title{Solve an integer progam with LattE}
\usage{
latte_optim(objective, constraints, type = c("max", "min"),
  method = c("lp", "cones"), dir = tempdir(), opts = "",
  quiet = TRUE, shell = FALSE)

latte_max(objective, constraints, method = c("lp", "cones"),
  dir = tempdir(), opts = "", quiet = TRUE)

latte_min(objective, constraints, method = c("lp", "cones"),
  dir = tempdir(), opts = "", quiet = TRUE)
}
\arguments{
\item{objective}{A linear polynomial to pass to \code{\link[=mp]{mp()}}, see examples}

\item{constraints}{A collection of linear polynomial (in)equalities that
define the feasibility region, the integers in the polytope}

\item{type}{\code{"max"} or \code{"min"}}

\item{method}{Method \code{"LP"} or \code{"cones"}}

\item{dir}{Directory to place the files in, without an ending /}

\item{opts}{Options; see the LattE manual at
\url{http://www.math.ucdavis.edu/~latte}}

\item{quiet}{Show latte output}

\item{shell}{Messages the shell code used to do the computation}
}
\value{
A named list with components \code{par}, a named-vector of optimizing
arguments, and \code{value}, the value of the objective function at the
optimial point.
}
\description{
\code{latte_max} and \code{latte_min} use LattE's \code{latte-maximize} and
\code{latte-minimize} functions to find the maximum or minimum of a linear
objective function over the integers points in a polytope (i.e. satisfying
linearity constraints). This makes use of the digging algorithm; see the
LattE manual at \url{http://www.math.ucdavis.edu/~latte} for details.
}
\examples{


if (has_latte()) {

latte_max(
  "-2 x + 3 y", 
  c("x + y <= 10", "x >= 0", "y >= 0")
)

latte_max(
  "-2 x + 3 y", 
  c("x + y <= 10", "x >= 0", "y >= 0"),
  quiet = FALSE
)


df <- expand.grid("x" = 0:10, "y" = 0:10)
df <- subset(df, x + y <= 10L)
df$objective <- with(df, -2*x + 3*y)
library("ggplot2")
ggplot(df, aes(x, y, size = objective)) +
  geom_point()

latte_min(
  "-2 x + 3 y",
  c("x + y <= 10", "x >= 0", "y >= 0"),
  method = "cones"
)



latte_min("-2 x - 3 y - 4 z", c(
  "3 x + 2 y + z <= 10",
  "2 x + 5 y + 3 z <= 15",
  "x >= 0", "y >= 0", "z >= 0"
), "cones", quiet = FALSE)





}

}
