% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{latrend-metrics}
\alias{latrend-metrics}
\title{Metrics}
\description{
The package supports a variety of metrics that help to evaluate and compare \link[=lcModel]{estimated models}.
\itemize{
\item \link[=metric]{Internal metrics}: metrics that assess the adequacy of the model with respect to the data.
\item \link[=externalMetric]{External metrics}: metrics that compare two models.
}

Users can implement new metrics through \code{\link[=defineInternalMetric]{defineInternalMetric()}} and \code{\link[=defineExternalMetric]{defineExternalMetric()}}.
Custom-defined metrics are accessible using the same by-name mechanism as the other metrics.
}
\section{Supported internal metrics}{
\tabular{lll}{
   \strong{Metric name} \tab \strong{Description} \tab \strong{Function / Reference} \cr
   \code{AIC} \tab \href{https://en.wikipedia.org/wiki/Akaike_information_criterion}{Akaike information criterion}. A goodness-of-fit estimator that adjusts for model complexity (i.e., the number of parameters). Only available for models that support the computation of the model log-likelihood through \link{logLik}. \tab \code{\link[stats:AIC]{stats::AIC()}}, \insertCite{akaike1974new}{latrend} \cr
   \code{APPA.mean} \tab Mean of the average posterior probability of assignment (APPA) across clusters. A measure of the precision of the trajectory classifications. A score of 1 indicates perfect classification. \tab \code{\link[=APPA]{APPA()}}, \insertCite{nagin2005group}{latrend} \cr
   \code{APPA.min} \tab Lowest APPA among the clusters \tab \code{\link[=APPA]{APPA()}}, \insertCite{nagin2005group}{latrend} \cr
   \code{ASW} \tab Average \href{https://en.wikipedia.org/wiki/Silhouette_(clustering)}{silhouette} width based on the Euclidean distance \tab \insertCite{rousseeuw1987silhouettes}{latrend} \cr
   \code{BIC} \tab \href{https://en.wikipedia.org/wiki/Bayesian_information_criterion}{Bayesian information criterion}. A goodness-of-fit estimator that corrects for the degrees of freedom (i.e., the number of parameters) and sample size. Only available for models that support the computation of the model log-likelihood through \link{logLik}. \tab \code{\link[stats:AIC]{stats::BIC()}}, \insertCite{schwarz1978estimating}{latrend} \cr
   \code{CAIC} \tab Consistent Akaike information criterion \tab \insertCite{bozdogan1987model}{latrend} \cr
   \code{CLC} \tab Classification likelihood criterion \tab \insertCite{mclachlan2000finite}{latrend} \cr
   \code{converged} \tab Whether the model converged during estimation \tab \code{\link[=converged]{converged()}} \cr
   \code{deviance} \tab The model \href{https://en.wikipedia.org/wiki/Deviance_(statistics)}{deviance} \tab \code{\link[stats:deviance]{stats::deviance()}} \cr
   \code{Dunn} \tab The \href{https://en.wikipedia.org/wiki/Dunn_index}{Dunn index} \tab \insertCite{dunn1974well}{latrend} \cr
   \code{entropy} \tab Entropy of the posterior probabilities \tab  \cr
   \code{estimationTime} \tab The time needed for fitting the model \tab \code{\link[=estimationTime]{estimationTime()}} \cr
   \code{ED} \tab \href{https://en.wikipedia.org/wiki/Euclidean_distance}{Euclidean distance} between the cluster trajectories and the assigned observed trajectories \tab  \cr
   \code{ED.fit} \tab Euclidean distance between the cluster trajectories and the assigned fitted trajectories \tab  \cr
   \code{ICL.BIC} \tab Integrated classification likelihood (ICL) approximated using the BIC \tab \insertCite{biernacki2000assessing}{latrend} \cr
   \code{logLik} \tab Model log-\href{https://en.wikipedia.org/wiki/Likelihood_function}{likelihood} \tab \code{\link[stats:logLik]{stats::logLik()}} \cr
   \code{MAE} \tab \href{https://en.wikipedia.org/wiki/Mean_absolute_error}{Mean absolute error} of the fitted trajectories (assigned to the most likely respective cluster) to the observed trajectories \tab  \cr
   \code{Mahalanobis} \tab \href{https://en.wikipedia.org/wiki/Mahalanobis_distance}{Mahalanobis distance} between the cluster trajectories and the assigned observed trajectories \tab \insertCite{mahalanobis1936generalized}{latrend} \cr
   \code{MSE} \tab \href{https://en.wikipedia.org/wiki/Mean_squared_error}{Mean squared error} of the fitted trajectories (assigned to the most likely respective cluster) to the observed trajectories \tab  \cr
   \code{relativeEntropy}, \code{RE} \tab A measure of the precision of the trajectory classification. A value of 1 indicates perfect classification, whereas a value of 0 indicates a non-informative uniform classification. It is the normalized version of \code{entropy}, scaled between [0, 1]. \tab \insertCite{ramaswamy1993empirical}{latrend}, \insertCite{muthen2004latent}{latrend} \cr
   \code{RMSE} \tab \href{https://en.wikipedia.org/wiki/Root-mean-square_deviation}{Root mean squared error} of the fitted trajectories (assigned to the most likely respective cluster) to the observed trajectories \tab  \cr
   \code{RSS} \tab \href{https://en.wikipedia.org/wiki/Residual_sum_of_squares}{Residual sum of squares} under most likely cluster allocation \tab  \cr
   \code{scaledEntropy} \tab See \code{relativeEntropy} \tab  \cr
   \code{sigma} \tab The residual standard deviation \tab \code{\link[stats:sigma]{stats::sigma()}} \cr
   \code{ssBIC} \tab Sample-size adjusted BIC \tab \insertCite{sclove1987application}{latrend} \cr
   \code{SED} \tab Standardized Euclidean distance between the cluster trajectories and the assigned observed trajectories \tab  \cr
   \code{SED.fit} \tab The cluster-weighted standardized Euclidean distance between the cluster trajectories and the assigned fitted trajectories \tab  \cr
   \code{WMAE} \tab \code{MAE} weighted by cluster-assignment probability \tab  \cr
   \code{WMSE} \tab \code{MSE} weighted by cluster-assignment probability \tab  \cr
   \code{WRMSE} \tab \code{RMSE} weighted by cluster-assignment probability \tab  \cr
   \code{WRSS} \tab \code{RSS} weighted by cluster-assignment probability \tab  \cr
}
}

\section{Supported external metrics}{
\tabular{lll}{
   \strong{Metric name} \tab \strong{Description} \tab \strong{Function / Reference} \cr
   \code{adjustedRand} \tab \href{https://en.wikipedia.org/wiki/Rand_index}{Adjusted Rand index}. Based on the Rand index, but adjusted for agreements occurring by chance. A score of 1 indicates a perfect agreement, whereas a score of 0 indicates an agreement no better than chance. \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}}, \insertCite{hubert1985comparing}{latrend} \cr
   \code{CohensKappa} \tab \href{https://en.wikipedia.org/wiki/Cohen\%27s_kappa}{Cohen's kappa}. A partitioning agreement metric correcting for random chance. A score of 1 indicates a perfect agreement, whereas a score of 0 indicates an agreement no better than chance. \tab \code{\link[psych:kappa]{psych::cohen.kappa()}}, \insertCite{cohen1960coefficient}{latrend} \cr
   \code{F} \tab \href{https://en.wikipedia.org/wiki/F-score}{F-score} \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{F1} \tab \href{https://en.wikipedia.org/wiki/F-score}{F1-score}, also referred to as the \href{https://en.wikipedia.org/wiki/S\%C3\%B8rensen\%E2\%80\%93Dice_coefficient}{Sørensen–Dice Coefficient}, or Dice similarity coefficient \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{FolkesMallows} \tab \href{https://en.wikipedia.org/wiki/Fowlkes\%E2\%80\%93Mallows_index}{Fowlkes-Mallows index} \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{Hubert} \tab Hubert index \tab \code{\link[clusterCrit:extCriteria]{clusterCrit::extCriteria()}} \cr
   \code{Jaccard} \tab \href{https://en.wikipedia.org/wiki/Jaccard_index}{Jaccard index} \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{jointEntropy} \tab \href{https://en.wikipedia.org/wiki/Joint_entropy}{Joint entropy} between model assignments \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{Kulczynski} \tab Kulczynski index \tab \code{\link[clusterCrit:extCriteria]{clusterCrit::extCriteria()}} \cr
   \code{MaximumMatch} \tab Maximum match measure \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{McNemar} \tab McNemar statistic \tab \code{\link[clusterCrit:extCriteria]{clusterCrit::extCriteria()}} \cr
   \code{MeilaHeckerman} \tab Meila-Heckerman measure \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{Mirkin} \tab Mirkin metric \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{MI} \tab \href{https://en.wikipedia.org/wiki/Mutual_information}{Mutual information} \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{NMI} \tab Normalized mutual information \tab \code{\link[igraph:compare]{igraph::compare()}} \cr
   \code{NSJ} \tab Normalized version of \code{splitJoin}. The proportion of edits relative to the maximum changes (twice the number of ids) \tab  \cr
   \code{NVI} \tab Normalized variation of information \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{Overlap} \tab \href{https://en.wikipedia.org/wiki/Overlap_coefficient}{Overlap coefficient}, also referred to as the Szymkiewicz–Simpson coefficient \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \insertCite{vijaymeena2016survey}{latrend} \cr
   \code{PD} \tab Partition difference \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{Phi} \tab \href{https://en.wikipedia.org/wiki/Phi_coefficient}{Phi coefficient}. \tab \code{\link[clusterCrit:extCriteria]{clusterCrit::extCriteria()}} \cr
   \code{precision} \tab \href{https://en.wikipedia.org/wiki/Precision_and_recall}{precision} \tab \code{\link[clusterCrit:extCriteria]{clusterCrit::extCriteria()}} \cr
   \code{Rand} \tab \href{https://en.wikipedia.org/wiki/Rand_index}{Rand index} \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{recall} \tab \href{https://en.wikipedia.org/wiki/Precision_and_recall}{recall} \tab \code{\link[clusterCrit:extCriteria]{clusterCrit::extCriteria()}} \cr
   \code{RogersTanimoto} \tab Rogers-Tanimoto dissimilarity \tab \code{\link[clusterCrit:extCriteria]{clusterCrit::extCriteria()}} \cr
   \code{RusselRao} \tab Russell-Rao dissimilarity \tab \code{\link[clusterCrit:extCriteria]{clusterCrit::extCriteria()}} \cr
   \code{SMC} \tab \href{https://en.wikipedia.org/wiki/Simple_matching_coefficient}{Simple matching coefficient} \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{splitJoin} \tab total split-join index \tab \code{\link[igraph:split_join_distance]{igraph::split_join_distance()}} \cr
   \code{splitJoin.ref} \tab Split-join index of the first model to the second model. In other words, it is the edit-distance between the two partitionings. \tab  \cr
   \code{SokalSneath1} \tab Type-1 Sokal-Sneath dissimilarity \tab \code{\link[clusterCrit:extCriteria]{clusterCrit::extCriteria()}} \cr
   \code{SokalSneath2} \tab Type-2 Sokal-Sneath dissimilarity \tab \code{\link[clusterCrit:extCriteria]{clusterCrit::extCriteria()}} \cr
   \code{VI} \tab \href{https://en.wikipedia.org/wiki/Variation_of_information}{Variation of information} \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{Wallace1} \tab Type-1 Wallace criterion \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{Wallace2} \tab Type-2 Wallace criterion \tab \code{\link[mclustcomp:mclustcomp]{mclustcomp::mclustcomp()}} \cr
   \code{WMSSE} \tab Weighted minimum sum of squared errors between cluster trajectories \tab  \cr
   \code{WMMSE} \tab Weighted minimum mean of squared errors between cluster trajectories \tab  \cr
   \code{WMMAE} \tab Weighted minimum mean of absolute errors between cluster trajectories \tab  \cr
}
}

\seealso{
\link{metric} \link{externalMetric}
}
