% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R, R/model.R
\name{getName}
\alias{getName}
\alias{getName,lcMethod-method}
\alias{getShortName}
\alias{getShortName,lcMethod-method}
\alias{getName,lcModel-method}
\alias{getShortName,lcModel-method}
\title{Get the (short) name of the lcMethod or Model}
\usage{
\S4method{getName}{lcMethod}(object, ...)

\S4method{getShortName}{lcMethod}(object, ...)

\S4method{getName}{lcModel}(object)

\S4method{getShortName}{lcModel}(object)
}
\arguments{
\item{object}{The \code{lcMethod} or \code{lcModel} object.}

\item{...}{Additional arguments.}
}
\value{
A \code{character} name.
}
\description{
Extract the full or shortened name of the given \code{lcMethod} or \code{lcModel} object.
The name of the fitted \code{lcModel} is determined by its associated \code{lcMethod} name and label, unless specified otherwise.
}
\section{Implementation}{

When implementing your own \code{lcMethod} subclass, override these methods to provide full and abbreviated names.
\preformatted{
setMethod("getName", "lcMethodExample", function(object) "example name")

setMethod("getShortName", "lcMethodExample", function(object) "EX")
}

Similar methods can be implemented for your \code{lcModel} subclass,
however in practice this is not needed as the names are determined by default from the \code{lcMethod} object that was used to fit the \code{lcModel} object.
}

\examples{
getName(lcMethodKML()) # "longitudinal k-means"
getShortName(lcMethodKML()) # "KML"
}
\seealso{
\link{getLabel}
}
