% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorize.R
\name{categorize}
\alias{categorize}
\title{Categorize Continuous Data}
\usage{
categorize(data, categories, skew_value = 0)
}
\arguments{
\item{data}{Numeric (length = n).
A vector of continuous data with \emph{n} values.
For matrices, use \code{apply}}

\item{categories}{Numeric (length = 1).
Number of categories to create.
Between 2 and 6 categories can be used with skew}

\item{skew_value}{Numeric (length = 1).
Value of skew.
Ranges between -2 to 2 in increments of 0.05.
Skews not in this sequence will be converted to
the nearest value in this sequence.
Defaults to \code{0} or no skew}
}
\value{
Returns a numeric vector of the categorize data
}
\description{
Categorizes continuous data based on Garrido, Abad and Ponsoda (2011; see references).
Categorical data with 2 to 6 categories can include skew between -2 to 2 in
increments of 0.05
}
\examples{
# Dichotomous data (no skew)
dichotomous <- categorize(
  data = rnorm(1000),
  categories = 2
)

# Dichotomous data (with positive skew)
dichotomous_skew <- categorize(
  data = rnorm(1000),
  categories = 2,
  skew_value = 1.25
)

# 5-point Likert scale (no skew)
five_likert <- categorize(
  data = rnorm(1000),
  categories = 5 
)

# 5-point Likert scale (negative skew)
five_likert <- categorize(
  data = rnorm(1000),
  categories = 5,
  skew_value = -0.45
)

}
\references{
Garrido, L. E., Abad, F. J., & Ponsoda, V. (2011). \cr
Performance of Velicer’s minimum average partial factor retention method with categorical variables. \cr
\emph{Educational and Psychological Measurement}, \emph{71}(3), 551-570.

Golino, H., Shi, D., Christensen, A. P., Garrido, L. E., Nieto, M. D., Sadana, R., ... & Martinez-Molina, A. (2020).
Investigating the performance of exploratory graph analysis and traditional techniques to identify the number of latent factors: A simulation and tutorial.
\emph{Psychological Methods}, \emph{25}(3), 292-320.
}
\author{
Maria Dolores Nieto Canaveras <mnietoca@nebrija.es>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>,
Hudson Golino <hfg9s@virginia.edu>,
Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
