% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EKC.R
\name{EKC}
\alias{EKC}
\title{Estimate Number of Dimensions using Empirical Kaiser Criterion}
\usage{
EKC(data, sample_size)
}
\arguments{
\item{data}{Matrix or data frame.
Either a dataset with all numeric values
(rows = cases, columns = variables) or
a symmetric correlation matrix}

\item{sample_size}{Numeric (length = 1).
If input into \code{data} is a correlation matrix,
then specifying the sample size is required}
}
\value{
Returns a list containing:

\item{dimensions}{Number of dimensions identified}

\item{eigenvalues}{Eigenvalues}

\item{reference}{Reference values compared against eigenvalues}
}
\description{
Estimates the number of dimensions in data using 
Empirical Kaiser Criterion (Braeken & Van Assen, 2017).
See examples to get started
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000 # number of cases = 1000
)

# Perform Empirical Kaiser Criterion
EKC(two_factor$data)

}
\references{
Braeken, J., & Van Assen, M. A. (2017).
An empirical Kaiser criterion.
\emph{Psychological Methods}, \emph{22}(3), 450–466.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s@virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>
}
