% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exports.R
\name{removeFromList}
\alias{removeFromList}
\title{Remove elements from a list file.}
\usage{
removeFromList(file, index)
}
\arguments{
\item{file}{Name of file.}

\item{index}{A numeric, logical or character vector.}
}
\value{
invisible \code{TRUE} if no error occurs.
}
\description{
Remove elements from a list file.
}
\details{
It removes elements with given indices or names. This function may relocate all the data 
in the stored file, thus can be very slow! Please consider to call this function 
batchwise instead of one index by one index. \cr
When it takes long time to process, some verbose info will be printed to console, 
which can be switched off by setting \code{options(list(largeList.report.progress = FALSE))}.
}
\examples{
list_1 <- list("A" = c(1,2), "B" = "abc", list(1, 2, 3))
saveList(object = list_1, file = "example.llo")

# by numeric indices
removeFromList(file = "example.llo", index = c(2))

# by name
removeFromList(file = "example.llo", index = c("A"))

# by logical indices
removeFromList(file = "example.llo", index = c(TRUE))

}
\seealso{
\code{\link{largeList}}
}
