% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{stocks_file}
\alias{stocks_file}
\title{Get Personal Portfolio's Data}
\usage{
stocks_file(
  file = NA,
  creds = NA,
  auto = TRUE,
  sheets = c("Portafolio", "Fondos", "Transacciones"),
  keep_old = TRUE,
  cache = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{file}{Character. Import an Excel file, local or from URL.}

\item{creds}{Character. Dropbox's credentials (see \code{get_creds()})}

\item{auto}{Boolean. Automatically use my local personal file? You might want
to set in into your .Renviron \code{LARES_PORTFOLIO=~/dir/to/your/file.xlsx} so you
can leave all other parameters as \code{NA} and use it every time.}

\item{sheets}{Character Vector. Names of each sheet containing Portfolio summary,
Cash, and Transactions information}

\item{keep_old}{Boolean. Include sold tickers even though not currently in portfolio?}

\item{cache}{Boolean. Use daily cache if available?}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be printed.}
}
\value{
List with portfolio, transactions, and cash data.frames.
}
\description{
This function lets the user download his personal Excel with his
Portfolio's data, locally or from Dropbox.
}
\examples{
\dontrun{
# Load lares dummy portfolio XLSX
file <- system.file("inst/docs", "dummyPortfolio.xlsx", package = "lares")
df <- stocks_file(
  file = file,
  sheets = c("Portafolio", "Fondos", "Transacciones"),
  keep_old = FALSE
)
}
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{daily_stocks}()},
\code{\link{etf_sector}()},
\code{\link{splot_change}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_hist}()},
\code{\link{stocks_obj}()},
\code{\link{stocks_quote}()},
\code{\link{stocks_report}()}

Other Credentials: 
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{get_credentials}()},
\code{\link{get_tweets}()},
\code{\link{mailSend}()},
\code{\link{queryDB}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()},
\code{\link{stocks_report}()}
}
\concept{Credentials}
\concept{Investment}
