% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_sheets.R
\name{writeGS}
\alias{writeGS}
\alias{writeGS4}
\title{Google Sheets Writing (API v4)}
\usage{
writeGS(
  data,
  title,
  sheet = "Hoja 1",
  range = "A1",
  reformat = FALSE,
  append = FALSE,
  json = NULL,
  email = NULL,
  api_key = NULL,
  server = FALSE,
  ...
)
}
\arguments{
\item{data}{Object (value, vector, dataframe, list)}

\item{title}{Character. Title of Google Drive file. Uses regular
expressions so you may fetch with patterns instead of names.}

\item{sheet}{Character. Working sheet to import}

\item{range}{Character. A cell range to read from}

\item{reformat}{Boolean. Reformat the affected cells?}

\item{append}{Boolean.}

\item{json}{Character. JSON filename with service auth}

\item{email}{Character. If you have multiple pre-authorized
accounts in your machine, you may non-interactively select
which one you wish to use by email and/or api_key.}

\item{api_key}{Character. If you have multiple pre-authorized
accounts in your machine, you may non-interactively select
which one you wish to use by email and/or api_key.}

\item{server}{Boolean. Force interacting auth process?}

\item{...}{Further read_sheet parameters}
}
\value{
No return value, called for side effects.
}
\description{
Write data into Google Sheets knowing the file's title. You may write
a single value into a cell or a data.frame into a cell range.
}
\seealso{
Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{holidays}()},
\code{\link{ip_data}()},
\code{\link{readGS}()},
\code{\link{splot_etf}()},
\code{\link{stocks_hist}()},
\code{\link{stocks_quote}()},
\code{\link{trendsRelated}()}

Other Google: 
\code{\link{filesGD}()},
\code{\link{queryGA}()},
\code{\link{readGS}()},
\code{\link{trendsRelated}()},
\code{\link{trendsTime}()}
}
\concept{Google}
\concept{Scrapper}
