% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrabble.R
\name{grepl_letters}
\alias{grepl_letters}
\title{Pattern Matching for Letters considering Blanks}
\usage{
grepl_letters(x, pattern, blank = "_")
}
\arguments{
\item{x}{Character vector}

\item{pattern}{Character. Character string containing a 
semi-regular expression which uses the following logic:
"a_b" means any character that contains "a" followed by 
something followed by "b", anywhere in the string.}

\item{blank}{Character. String to use between letters.}
}
\value{
Boolean check for each value on \code{x}.
}
\description{
Match pattern of letters considering blanks within each element of a 
character vector, allowing counted characters between and around 
each letter. Used as an auxiliary function for the Scrabble family
of functions.
}
\examples{
x <- c("aaaa", "bbbb", "baba", "aabb", "a", "ab")
grepl_letters(x, "ab")
grepl_letters(x, "_ab")
grepl_letters(x, "a_a")
grepl_letters(x, "c")
}
