% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{formatText}
\alias{formatText}
\title{Format a string text as markdown/HTML}
\usage{
formatText(text, color = "black", size = 20, bold = FALSE)
}
\arguments{
\item{text}{Character. Strings to format.}

\item{color}{Character. Hex colour code.}

\item{size}{Numeric. Text size.}

\item{bold}{Boolean. Should the text be bold?}
}
\value{
String with format characters included.
}
\description{
Format any character string to HTML or markdown format. We 
recommend using this format with the \code{ggtext::geom_richtext}
function to format text in \code{ggplot2} objects.
}
\examples{
formatText("Text test", color = "#000000")
formatText(c(123, 456), color = "orange", size = 120, bold = TRUE)

# If you want to use it with \code{ggtext}:
\dontrun{
col1 <- "grey"
col2 <- "orange"
pt <- data.frame(
  label = paste0(
    formatText(123, color = col2, size = 120, bold = TRUE), "<br/>",
    formatText("of children had a", col1),"<br/>",
    formatText("traditional stay-at-home mom", color = col2, bold = TRUE), "<br/>",
    formatText(paste0("in 2012, compared to ", 321," in 1970"), color = col1)))
  ggplot(pt, aes(x = 0, y = 0))  +
  ggtext::geom_richtext(
    aes(label = label), 
    hjust = 0, 
    label.color = NA, 
    lineheight = 1.5) +
  xlim(0, 0.01) + theme_void()
}
}
