% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/definition.R
\docType{data}
\name{DefinitionCache}
\alias{DefinitionCache}
\title{A data structure to hold function definition locations}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
DefinitionCache
}
\description{
The key reason for using this rather than a \code{list} is that this also cleans up
when functions are removed from files.
}
\section{Methods}{

\itemize{
\item \code{get(funct)}: get the \code{location} of a definition, or \code{NULL} if it is not found
\item \code{get_functs_for_uri(uri)}: get the \code{location}s of all the definitions in \code{uri}
\item \code{filter(pattern)}: get the \code{location}s of all the definitions matching \code{pattern}
\item \code{update(uri, ranges)}: create \code{locations} of functions in \code{uri} from \code{ranges}, and
remove functions no longer in \code{uri}
}
}

\keyword{datasets}
