% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{loadDispersalHost}
\alias{loadDispersalHost}
\title{Load a host dispersal matrix}
\usage{
loadDispersalHost(params, type = "no")
}
\arguments{
\item{params}{a LandsepiParams Object.}

\item{type}{a character string specifying the type of dispersal ("no" for no dispersal)}
}
\value{
a vectorised dispersal matrix.
}
\description{
It loads a vectorised diagonal matrix to simulate no host dispersal.
}
\details{
as the size of the matrix depends on the number of fields in the landscape,
the landscape must be defined before calling \code{loadDispersalHost}.
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setLandscape(simul_params, loadLandscape(1))
d <- loadDispersalHost(simul_params)
d
}
}
\seealso{
\link{setDispersalHost}
}
