% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{epid_output}
\alias{epid_output}
\title{Generation of epidemiological and economic model outputs}
\usage{
epid_output(
  types = "all",
  time_param,
  Npatho,
  area,
  rotation,
  croptypes,
  cultivars_param,
  eco_param,
  GLAnoDis = cultivars_param$max_density[1],
  ylim_param = list(audpc = c(0, 0.76), audpc_rel = c(0, 1), gla = c(0, 1.48), gla_rel
    = c(0, 1), eco_cost = c(0, NA), eco_yield = c(0, NA), eco_product = c(0, NA),
    eco_margin = c(NA, NA)),
  writeTXT = TRUE,
  graphic = TRUE,
  path = getwd()
)
}
\arguments{
\item{types}{a character string (or a vector of character strings if several outputs are to be computed)
specifying the type of outputs to generate (see details):\itemize{
\item "audpc": Area Under Disease Progress Curve
\item "audpc_rel": Relative Area Under Disease Progress Curve
\item "gla": Green Leaf Area
\item "gla_rel": Relative Green Leaf Area
\item "eco_yield": Total crop yield
\item "eco_cost": Operational crop costs
\item "eco_product": Crop products
\item "eco_margin": Margin (products - operational costs)
\item "HLIR_dynamics", "H_dynamics", "L_dynamics", "IR_dynamics", "HLI_dynamics", etc.: Epidemic dynamics
related to the specified sanitary status (H, L, I or R and all their combinations).
Graphics only, works only if graphic=TRUE.
\item "all": compute all these outputs (default).
}}

\item{time_param}{list of simulation parameters:\itemize{
\item Nyears = number cropping seasons,
\item nTSpY = number of time-steps per cropping season.
}}

\item{Npatho}{number of pathogen genotypes.}

\item{area}{a vector containing polygon areas (must be in square meters).}

\item{rotation}{a dataframe containing for each field (rows) and year (columns, named "year_1", "year_2", etc.),
the index of the cultivated croptype. Importantly, the matrix must contain 1 more column than the real number
of simulated years.}

\item{croptypes}{a dataframe with three columns named 'croptypeID' for croptype index,
'cultivarID' for cultivar index and 'proportion' for the proportion of the cultivar within the croptype.}

\item{cultivars_param}{list of parameters associated with each host genotype (i.e. cultivars):
\itemize{
\item name = vector of cultivar names,
\item initial_density = vector of host densities (per square meter) at the beginning of the cropping season
as if cultivated in pure crop,
\item max_density = vector of maximum host densities (per square meter) at the end of the cropping season
as if cultivated in pure crop,
\item cultivars_genes_list = a list containing, for each host genotype, the indices of carried resistance genes.
}}

\item{eco_param}{a list of economic parameters for each host genotype as if cultivated in pure crop:\itemize{
\item yield_perHa = a dataframe of 4 columns for the theoretical yield associated with hosts in sanitary status H, L, I and R,
as if cultivated in pure crops, and one row per host genotype
(yields are expressed in weight or volume units / ha / cropping season),
\item planting_cost_perHa = a vector of planting costs (in monetary units / ha / cropping season),
\item market_value = a vector of market values of the production (in monetary units / weight or volume unit).
}}

\item{GLAnoDis}{the value of absolute GLA in absence of disease (required to compute economic outputs).}

\item{ylim_param}{a list of graphical parameters for each required output: bounds for y-axes for
audpc, gla, gla_rel, eco_cost, eco_yield, eco_product, eco_margin.}

\item{writeTXT}{a logical indicating if the output is written in a text file (TRUE) or not (FALSE).}

\item{graphic}{a logical indicating if a tiff graphic of the output is generated (only if more than one year is simulated).}

\item{path}{path of text file (if writeTXT = TRUE) and tiff graphic (if graphic = TRUE) to be generated.}
}
\value{
A list containing, for each required type of output, a matrix summarising the output for each year and cultivar
(as well as the whole landscape).
Each matrix can be written in a txt file (if writeTXT=TRUE), and illustrated in a graphic (if graphic=TRUE).
}
\description{
Generates epidemiological and economic outputs from model simulations.
}
\details{
Outputs are computed every year for every cultivar as well as for the whole landscape. \describe{
\item{\strong{Epidemiological outputs.}}{
The epidemiological impact of pathogen spread can be evaluated by different measures: \enumerate{
\item Area Under Disease Progress Curve (AUDPC): average number of diseased host individuals (status I + R)
per time step and square meter.
\item Relative Area Under Disease Progress Curve (AUDPCr): average proportion of diseased host individuals
(status I + R) relative to the total number of existing hosts (H+L+I+R).
\item Green Leaf Area (GLA): average number of healthy host individuals (status H) per time step and per square meter.
\item Relative Green Leaf Area (GLAr): average proportion of healthy host individuals (status H) relative to the total number
of existing hosts (H+L+I+R).
}
}
\item{\strong{Economic outputs.}}{
The economic outcome of a simulation can be evaluated using: \enumerate{
\item Crop yield: yearly crop yield (e.g. grains, fruits, wine) in weight (or volume) units
per hectare (depends on the number of productive hosts and associated theoretical yield).
\item Crop products: yearly product generated from sales, in monetary units per hectare
(depends on crop yield and market value).
\item Operational crop costs: yearly costs associated with crop planting in monetary units per hectare
(depends on initial host density and planting cost).
\item Crop margin, i.e. products - operational costs, in monetary units per hectare.
}
}
}
}
\examples{
\dontrun{
demo_landsepi()
}
}
\references{
Rimbaud L., Papaïx J., Rey J.-F., Barrett L. G. and Thrall P. H. (2018). Assessing the durability and efficiency of
landscape-based strategies to deploy plant resistance to pathogens. \emph{PLoS Computational Biology} 14(4):e1006067.
}
\seealso{
\link{evol_output}
}
