% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_area_cv.R
\name{lsm_l_area_cv}
\alias{lsm_l_area_cv}
\title{AREA_CV (landscape level)}
\usage{
lsm_l_area_cv(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Coefficient of variation of patch area (Area and edge metric)
}
\details{
\deqn{AREA_{CV} = cv(AREA[patch_{ij}])}
where \eqn{AREA[patch_{ij}]} is the area of each patch in hectares.

AREA_CV is an 'Area and Edge metric'. The metric summarises the landscape
as the Coefficient of variation of all patches in the landscape.
The metric describes the differences among patches in the landscape and is
easily comparable because it is scaled to the mean.

\subsection{Units}{Hectares}
\subsection{Range}{AREA_CV >= 0}
\subsection{Behaviour}{Equals AREA_CV = 0 if all patches are identical in size.
Increases, without limit, as the variation of patch areas increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_area_cv(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_p_area}}, \cr
\code{\link{lsm_c_area_mn}},
\code{\link{lsm_c_area_sd}},
\code{\link{lsm_c_area_cv}}, \cr
\code{\link{lsm_l_area_mn}},
\code{\link{lsm_l_area_sd}}
}
