% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_area_sd.R
\name{lsm_c_area_sd}
\alias{lsm_c_area_sd}
\title{AREA_SD (class level)}
\usage{
lsm_c_area_sd(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Standard deviation of patch area (Area and edge metric)
}
\details{
\deqn{AREA_{SD} = sd(AREA[patch_{ij}])}
where \eqn{AREA[patch_{ij}]} is the area of each patch in hectares.

AREA_SD is an 'Area and Edge metric'. The metric summarises each class
as the standard deviation of all patch areas belonging to class i.
The metric describes the differences among patches of the same class i in
the landscape.

\subsection{Units}{Hectares}
\subsection{Range}{AREA_SD >= 0}
\subsection{Behaviour}{Equals AREA_SD = 0 if all patches are identical in size.
Increases, without limit, as the variation of patch areas increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_area_sd(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{sd}}, \cr
\code{\link{lsm_c_area_mn}},
\code{\link{lsm_c_area_cv}}, \cr
\code{\link{lsm_l_area_mn}},
\code{\link{lsm_l_area_sd}},
\code{\link{lsm_l_area_cv}}
}
