% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_extras.R
\name{get_area_patches}
\alias{get_area_patches}
\title{get_area_patches}
\usage{
get_area_patches(class_patches, classes, resolution)
}
\arguments{
\item{class_patches}{A list with matrices of patches for each class (output of get_class_patches)}

\item{classes}{A vector with unique values (output of get_unique_values_int)}

\item{resolution}{A vector with two numbers (usually calculated using terra::res)}
}
\value{
list with vectors of areas of patches for each class
}
\description{
Get areas of patches for each class
}
\details{
Calculate areas of patches for each class
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
landscape_mat <- terra::as.matrix(landscape, wide = TRUE)
classes <- landscapemetrics:::get_unique_values_int(landscape_mat)
class_patches <- get_class_patches(landscape_mat, classes, directions = 8)
area_patches <- get_area_patches(class_patches, classes, resolution = terra::res(landscape))

}
\keyword{internal}
