% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_nlsi.R
\name{lsm_c_nlsi}
\alias{lsm_c_nlsi}
\title{nLSI (class level)}
\usage{
lsm_c_nlsi(landscape)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}
}
\value{
tibble
}
\description{
Normalized landscape shape index (Aggregation metric)
}
\details{
\deqn{nLSI = \frac{e_{i} - \min e_{i}} {\max e_{i} - \min e_{i}}}
where \eqn{e_{i}} is the total edge length in cell surfaces and \eqn{\min e_{i}}
\eqn{\max e_{i}} are the minimum and maximum total edge length in cell surfaces, respectively.

nLSI is an 'Aggregation metric'. It is closely related to the \code{\link{lsm_c_lsi}}
and describes the ratio of the actual edge length of class i in relation to the
hypothetical range of possible edge lengths of class i (min/max).

Currently, nLSI ignores all background cells when calculating the minimum and maximum
total edge length. Also, a correct calculation of the minimum and maximum
total edge length is currently only possible for rectangular landscapes.

\subsection{Units}{None}
\subsection{Ranges}{0 <= nlsi <= 1}
\subsection{Behaviour}{Equals nLSI = 0 when only one squared patch is present. nLSI
increases the more disaggregated patches are and equals nLSI = 1 for a maximal disaggregated
(i.e. a "checkerboard pattern").}
}
\examples{
lsm_c_nlsi(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

Patton, D. R. 1975. A diversity index for quantifying habitat "edge".
Wildl. Soc.Bull. 3:171-173.
}
\seealso{
\code{\link{lsm_c_lsi}}
\code{\link{lsm_l_lsi}}
}
