% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_dcore_cv.R
\name{lsm_l_dcore_cv}
\alias{lsm_l_dcore_cv}
\alias{lsm_l_dcore_cv.RasterLayer}
\alias{lsm_l_dcore_cv.RasterStack}
\alias{lsm_l_dcore_cv.RasterBrick}
\alias{lsm_l_dcore_cv.stars}
\alias{lsm_l_dcore_cv.list}
\title{DCORE_CV (landscape level)}
\usage{
lsm_l_dcore_cv(landscape, directions, consider_boundary, edge_depth)

\method{lsm_l_dcore_cv}{RasterLayer}(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)

\method{lsm_l_dcore_cv}{RasterStack}(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)

\method{lsm_l_dcore_cv}{RasterBrick}(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)

\method{lsm_l_dcore_cv}{stars}(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)

\method{lsm_l_dcore_cv}{list}(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Coefficient of variation number of disjunct core areas (Core area metric)
}
\details{
\deqn{DCORE_{CV} = cv(NCORE[patch_{ij}])}
where \eqn{NCORE[patch_{ij}]} is the number of core areas.

DCORE_CV is an 'Core area metric'. It summarises the landscape as the Coefficient
of variation of all patches belonging to the landscape. A cell is defined as core if
the cell has no neighbour with a different value than itself (rook's case). NCORE counts
the disjunct core areas, whereby a core area is a 'patch within the patch' containing
only core cells. The metric describes the differences among all patches in the landscape
and is easily comparable because it is scaled to the mean.

\subsection{Units}{None}
\subsection{Range}{DCORE_CV >= 0}
\subsection{Behaviour}{Equals DCORE_CV = 0 if all patches have the same number of disjunct
core areas. Increases, without limit, as the variation of number of disjunct core areas
increases.}
}
\examples{
lsm_l_dcore_cv(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_ncore}},
\code{\link{cv}}, \cr
\code{\link{lsm_c_dcore_mn}},
\code{\link{lsm_c_dcore_sd}},
\code{\link{lsm_c_dcore_cv}}, \cr
\code{\link{lsm_l_dcore_mn}},
\code{\link{lsm_l_dcore_sd}}
}
