% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_frac_sd.R
\name{lsm_c_frac_sd}
\alias{lsm_c_frac_sd}
\alias{lsm_c_frac_sd.RasterLayer}
\alias{lsm_c_frac_sd.RasterStack}
\alias{lsm_c_frac_sd.RasterBrick}
\alias{lsm_c_frac_sd.stars}
\alias{lsm_c_frac_sd.list}
\title{FRAC_SD (class level)}
\usage{
lsm_c_frac_sd(landscape, directions)

\method{lsm_c_frac_sd}{RasterLayer}(landscape, directions = 8)

\method{lsm_c_frac_sd}{RasterStack}(landscape, directions = 8)

\method{lsm_c_frac_sd}{RasterBrick}(landscape, directions = 8)

\method{lsm_c_frac_sd}{stars}(landscape, directions = 8)

\method{lsm_c_frac_sd}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Standard deviation fractal dimension index (Shape metric)
}
\details{
\deqn{FRAC_{SD} = sd(FRAC[patch_{ij}])}
where \eqn{FRAC[patch_{ij}]} equals the fractal dimension index of each patch.

FRAC_SD is a 'Shape metric'. The metric summarises each class
as the standard deviation of the fractal dimension index of all patches
belonging to class i. The fractal dimension index is based on the patch perimeter and
the patch area and describes the patch complexity.

\subsection{Units}{None}
\subsection{Range}{FRAC_SD>= 0 }
\subsection{Behaviour}{Equals FRAC_SD = 0 if the fractal dimension index is identical
for all patches. Increases, without limit, as the variation of the fractal dimension
indices increases.}
}
\examples{
lsm_c_frac_sd(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Mandelbrot, B. B. 1977. Fractals: Form, Chance, and Dimension.
San Francisco. W. H. Freeman and Company.
}
\seealso{
\code{\link{lsm_p_frac}},
\code{\link{sd}}, \cr
\code{\link{lsm_c_frac_mn}},
\code{\link{lsm_c_frac_cv}}, \cr
\code{\link{lsm_l_frac_mn}},
\code{\link{lsm_l_frac_sd}},
\code{\link{lsm_l_frac_cv}}
}
