% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_contig_cv.R
\name{lsm_l_contig_cv}
\alias{lsm_l_contig_cv}
\alias{lsm_l_contig_cv.RasterLayer}
\alias{lsm_l_contig_cv.RasterStack}
\alias{lsm_l_contig_cv.RasterBrick}
\alias{lsm_l_contig_cv.stars}
\alias{lsm_l_contig_cv.list}
\title{CONTIG_CV (landscape level)}
\usage{
lsm_l_contig_cv(landscape, directions)

\method{lsm_l_contig_cv}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_contig_cv}{RasterStack}(landscape, directions = 8)

\method{lsm_l_contig_cv}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_contig_cv}{stars}(landscape, directions = 8)

\method{lsm_l_contig_cv}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Coefficient of variation of Contiguity index (Shape metric)
}
\details{
\deqn{CONTIG_{CV} =  cv(CONTIG[patch_{ij}])}

where \eqn{CONTIG[patch_{ij}]} is the contiguity of each patch.

CONTIG_CV is a 'Shape metric'. It summarises the landscape as the coefficient of variation of all patches
in the landscape. CONTIG_CV asses the spatial connectedness (contiguity) of
cells in patches. The metric coerces patch values to a value of 1 and the background
to NA. A nine cell focal filter matrix:\preformatted{filter_matrix <- matrix(c(1, 2, 1,
                          2, 1, 2,
                          1, 2, 1), 3, 3, byrow = T)
}

... is then used to weight orthogonally contiguous pixels more heavily than
diagonally contiguous pixels. Therefore, larger and more connections between
patch cells in the rookie case result in larger contiguity index values.

\subsection{Units}{None}
\subsection{Range}{CONTIG_CV >= 0}
\subsection{Behaviour}{CONTIG_CV = 0 if the contiguity index is
identical for all patches. Increases, without limit, as the variation of
CONTIG increases.}
}
\examples{
lsm_l_contig_cv(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

LaGro, J. 1991. Assessing patch shape in landscape mosaics.
Photogrammetric Engineering and Remote Sensing, 57(3), 285-293
}
\seealso{
\code{\link{lsm_p_contig}},
\code{\link{lsm_c_contig_sd}},
\code{\link{lsm_c_contig_cv}},
\code{\link{lsm_c_contig_mn}}, \cr
\code{\link{lsm_l_contig_sd}},
\code{\link{lsm_l_contig_mn}}
}
