% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_circumscribingcircle.R
\name{get_circumscribingcircle}
\alias{get_circumscribingcircle}
\alias{get_circumscribingcircle.RasterLayer}
\alias{get_circumscribingcircle.RasterStack}
\alias{get_circumscribingcircle.RasterBrick}
\alias{get_circumscribingcircle.stars}
\alias{get_circumscribingcircle.list}
\alias{get_circumscribingcircle.matrix}
\title{get_circumscribingcircle}
\usage{
get_circumscribingcircle(landscape, resolution_x, resolution_y)

\method{get_circumscribingcircle}{RasterLayer}(landscape, resolution_x = NULL, resolution_y = NULL)

\method{get_circumscribingcircle}{RasterStack}(landscape, resolution_x = NULL, resolution_y = NULL)

\method{get_circumscribingcircle}{RasterBrick}(landscape, resolution_x = NULL, resolution_y = NULL)

\method{get_circumscribingcircle}{stars}(landscape, resolution_x = NULL, resolution_y = NULL)

\method{get_circumscribingcircle}{list}(landscape, resolution_x = NULL, resolution_y = NULL)

\method{get_circumscribingcircle}{matrix}(landscape, resolution_x = NULL, resolution_y = NULL)
}
\arguments{
\item{landscape}{RasterLayer or matrix (with x, y, id columns)}

\item{resolution_x}{Resolution of the landscape (only needed if matrix as input is used)}

\item{resolution_y}{Resolution of the landscape (only needed if matrix as input is used)}
}
\description{
Diameter of the circumscribing circle around patches
}
\details{
The diameter of the smallest circumscribing circle around a patch in the landscape
is based on the maximum distance between the corners of each cell. This ensures that all
cells of the patch are included in the patch. All patches need an unique
ID (see \code{\link{get_patches}}). If one uses this functions with a matrix the
resolution of the underlying data must be provided.
}
\examples{
# get patches for class 1 from testdata as raster
class_1 <- get_patches(landscape, class = 1)[[1]]

# calculate the minimum circumscribing circle of each patch in class 1
get_circumscribingcircle(class_1)

# do the same with a 3 column matrix (x, y, id)
class_1_matrix <- raster::rasterToPoints(class_1)
get_circumscribingcircle(class_1_matrix, resolution_x = 1, resolution_y = 1)

}
