% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spfkm.R
\name{spfkm,formula,SpatialPointsDataFrame,SpatialPixelsDataFrame-method}
\alias{spfkm,formula,SpatialPointsDataFrame,SpatialPixelsDataFrame-method}
\alias{spfkm}
\title{Fit a supervised fuzzy kmeans model and predict memberships}
\usage{
\S4method{spfkm}{formula,SpatialPointsDataFrame,SpatialPixelsDataFrame}(
  formulaString,
  observations,
  covariates,
  class.c = NULL,
  class.sd = NULL,
  fuzzy.e = 1.2
)
}
\arguments{
\item{formulaString}{formula.}

\item{observations}{SpatialPointsDataFrame.}

\item{covariates}{SpatialPixelsDataFrame.}

\item{class.c}{class centers (per variable).}

\item{class.sd}{class standard deviation (per variable).}

\item{fuzzy.e}{fuzzy coefficient.}
}
\value{
A fuzzy kmeans model
}
\description{
Runs supervised fuzzy \emph{k}-means (Hengl et al., 2004; \doi{10.1080/13658810310001620924}) using a list of covariates layers provided as \code{"SpatialPixelsDataFrame-class"} object. If class centres and variances are not provided, it first fits a multinomial logistic regression model (\code{spmultinom}), then predicts the class centers and variances based on the output from the \code{nnet::multinom}.
}
\examples{
library(plotKML)
library(sp)

data(eberg)
# subset to 20\%:
eberg <- eberg[runif(nrow(eberg))<.2,]
data(eberg_grid)
coordinates(eberg) <- ~X+Y
proj4string(eberg) <- CRS("+init=epsg:31467")
gridded(eberg_grid) <- ~x+y
proj4string(eberg_grid) <- CRS("+init=epsg:31467")
# derive soil predictive components:
eberg_spc <- spc(eberg_grid, ~PRMGEO6+DEMSRT6+TWISRT6+TIRAST6)
# predict memberships:
formulaString = soiltype ~ PC1+PC2+PC3+PC4+PC5+PC6+PC7+PC8+PC9+PC10
eberg_sm <- spfkm(formulaString, eberg, eberg_spc@predicted)
\donttest{
# plot memberships:
  pal = seq(0, 1, 1/50)
  spplot(eberg_sm@mu, col.regions=grey(rev(pal)))
}
}
\author{
\href{https://opengeohub.org/people/tom-hengl}{Tom Hengl}
}
