% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_lamindb}
\alias{install_lamindb}
\title{Install LaminDB}
\usage{
install_lamindb(
  ...,
  envname = "r-lamindb",
  extra_packages = NULL,
  new_env = identical(envname, "r-lamindb"),
  use = TRUE
)
}
\arguments{
\item{...}{Additional arguments passed to \code{reticulate::py_install()}}

\item{envname}{String giving the name of the environment to install packages
into}

\item{extra_packages}{A vector giving the names of additional Python packages
to install}

\item{new_env}{Whether to remove any existing \code{virtualenv} with the same name
before creating a new one with the requested packages}

\item{use}{Whether to attempt use the new environment}
}
\value{
\code{NULL}, invisibly
}
\description{
Create a Python environment containing \strong{lamindb} or install \strong{lamindb}
into an existing environment.
}
\details{
See \code{vignette("setup", package = "laminr")} for further details on setting up
a Python environment
}
\examples{
\dontrun{
install_lamindb()

# Add additional packages to the environment
install_lamindb(extra_packages = c("bionty", "wetlab"))

# Install into a different environment
install_lamindb(envvname = "your-env")
}
}
