% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_slides_auth.R
\name{ladder_auth_configure}
\alias{ladder_auth_configure}
\alias{ladder_api_key}
\alias{ladder_oauth_client}
\title{Edit and view auth configuration}
\usage{
ladder_auth_configure(client, path, api_key, app)

ladder_api_key()

ladder_oauth_client()
}
\arguments{
\item{client}{A Google OAuth client, presumably constructed via
\code{\link[gargle:gargle_oauth_client_from_json]{gargle::gargle_oauth_client_from_json()}}. Note, however, that it is
preferred to specify the client with JSON, using the \code{path} argument.}

\item{path}{JSON downloaded from \href{https://console.cloud.google.com}{Google Cloud Console}, containing a client id and
secret, in one of the forms supported for the \code{txt} argument of
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a file path or JSON string).}

\item{api_key}{API key.}

\item{app}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Replaced by the \code{client}
argument.}
}
\value{
\itemize{
\item \code{ladder_auth_configure()}: An object of R6 class
\link[gargle:AuthState-class]{gargle::AuthState}, invisibly.
\item \code{ladder_oauth_client()}: the current user-configured OAuth client.
\item \code{ladder_api_key()}: the current user-configured API key.
}
}
\description{
These functions give more control over and visibility into the auth
configuration than \code{\link[=ladder_auth]{ladder_auth()}} does. \code{ladder_auth_configure()}
lets the user specify their own:
\itemize{
\item OAuth client, which is used when obtaining a user token.
\item API key. If ladder is de-authorized via \code{\link[=ladder_deauth]{ladder_deauth()}}, all
requests are sent with an API key in lieu of a token.
}

See the \code{vignette("get-api-credentials", package = "gargle")}
for more.
If the user does not configure these settings, internal defaults
are used.

\code{ladder_oauth_client()} and \code{ladder_api_key()} retrieve the
currently configured OAuth client and API key, respectively.
}
\examples{
# see and store the current user-configured OAuth client (probaby `NULL`)
(original_client <- ladder_oauth_client())

# see and store the current user-configured API key (probaby `NULL`)
(original_api_key <- ladder_api_key())

# the preferred way to configure your own client is via a JSON file
# downloaded from Google Developers Console
# this example JSON is indicative, but fake
path_to_json <- system.file(
  "extdata", "client_secret_installed.googleusercontent.com.json",
  package = "gargle"
)
ladder_auth_configure(path = path_to_json)

# this is also obviously a fake API key
ladder_auth_configure(api_key = "the_key_I_got_for_a_google_API")

# confirm the changes
ladder_oauth_client()
ladder_api_key()

# restore original auth config
ladder_auth_configure(client = original_client, api_key = original_api_key)
}
\seealso{
Other auth functions: 
\code{\link{ladder_auth}()},
\code{\link{ladder_deauth}()}
}
\concept{auth functions}
