% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/innerprodim.R
\name{innerprod.im}
\alias{innerprod.im}
\title{Inner Product of Two Functions Represented as Images}
\usage{
innerprod.im(A, B, outsideA = NA, outsideB = NA, na.rm = FALSE)
}
\arguments{
\item{A}{An \code{im} object containing function values representing function \eqn{f}.}

\item{B}{An \code{im} object containing function values representing function \eqn{g}.}

\item{outsideA}{The value of \eqn{f} outside the domain of \code{A}. Typically will be 0 or NA. Default is NA.}

\item{outsideB}{The value of \eqn{g} outside the domain of \code{B}. Typically will be \code{0} or \code{NA}. Default is \code{NA}.}

\item{na.rm}{Logical. If TRUE NA values are skipped in the summation of the product of the images.}
}
\value{
If the inner product can be computed then returns sum(\code{A} * \code{B}), otherwise returns \code{NA}.
}
\description{
Given two functions, f and g, that map from 2D space to 1D, and values of f and g represented as \code{im} objects
 then \code{innerprod.im} computes the (function space) inner product
\deqn{\int f(v) g(v) dv.}
}
\details{
This function harmonises the two input images, multiplies them together and returns the
integral of the resulting image.
 \code{outsideA} and \code{outsideB} are used to determine result if the inner product requires
values outside the domain of A or B. For example if \code{outsideA=0} and the
domain of \code{B} is larger than \code{A}'s domain then the inner product
can still be computed. However if \code{A} is \code{NA} outside (e.g. not
known/not provided) and the domain of \code{B} is larger than \code{A}'s
domain then the inner product can not be computed and the returned value is \code{NA}
}
\examples{
xi <- heather$coarse
covar <- plugincvc(xi, Frame(xi))
B <- setcov(square(1))
innerprod.im(covar, B, outsideB = 0)
}
