% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{prepare_fit}
\alias{prepare_fit}
\title{Prepare fit}
\usage{
prepare_fit(
  .data,
  fit = c("3rd degree polynomial", "4th degree polynomial", "B-spline", "Exponential"),
  include_baseline = FALSE,
  sport = c("cycling", "running", "swimming")
)
}
\arguments{
\item{.data}{The data retrieved from \code{prepare_data()}.}

\item{fit}{The fit you would like to use for finding the lactate values associated to each one of the lactate thresholds.
Please, note that a few lactate thresholds have default methods for this and cannot be changed. See \code{Details}.}

\item{include_baseline}{A boolean to indicate whether to include the baseline value in the fit.}

\item{sport}{The sport at which the incremental test was performed. One of \code{cycling}, \code{running}, or \code{swimming}.}
}
\value{
a tibble with the following nested columns:
\item{data}{The raw data.}
\item{data_interpolated}{The interpolated data.}
\item{model}{The model chosen in the \code{fit} parameter.}
\item{data_augmented}{The augmented data retrieved from the model.}
\item{bsln}{A boolean indicating the \code{include_baseline} argument.}
}
\description{
This is an obligatory step before applying any lactate threshold method.
This function will model the raw data as well as make all the necessary data wrangling.
}
\keyword{internal}
