% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irregular2.R
\name{irregular2}
\alias{irregular2}
\title{Convert All "Irregular" Data Frame Values to NA or Other Specified Value}
\usage{
irregular2(
  data,
  vars = NULL,
  to = NA,
  nan.include = TRUE,
  inf.include = TRUE,
  special = c("NA", "NAN", "INF", "-INF")
)
}
\arguments{
\item{data}{a data.frame object.}

\item{vars}{a character vector that corresponds to the name(s) of one or more
variables (columns) to which the operational will be applied. If NULL, will
be applied to all variables.}

\item{to}{a single value (by default: NA) to which all irregular values will
be converted (Note: if arg is character, returned vector will be coerced to
character).}

\item{nan.include}{convert NaN values to NA.}

\item{inf.include}{convert Inf and -Inf values to NA.}

\item{special}{additional specific character values that will be
converted to NA values.}
}
\value{
a data.frame identical to data, with exception that irregular values
have been converted to the value specified in "to" argument (NA, by default).
}
\description{
Check all (or specified) columns of a data.frame for the presence of
"irregular" values (e.g., NA, Inf, NaN) and, if found, replace them with NA
(or some other specified value).
}
\details{
For purposes of \code{irregular2}, irregular values consist of: NA values, other
arbitrary values you specify, and (by default): NaN, Inf, -Inf, and character
variants of same (i.e., upper, lower, or mixed-case variants of "NA","NAN",
"INF","-INF"). This function converts all such values to NA (or some other
specified value).
}
\examples{
set.seed(123)
x <- c(NA, Inf, -Inf, NaN, runif(6))
y <- c("a", "inf", "NaN", NA, sample(letters, 6, replace = TRUE))
df <- data.frame(x, y)

head(df, 10)

df_1 <- irregular2(df)

head(df_1, 10)

df_2 <- irregular2(df, vars = "x", to = ";-)")

head(df_2)
}
