% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/herbarium.R
\name{create_herbarium_label}
\alias{create_herbarium_label}
\title{Create herbarium labels}
\usage{
create_herbarium_label(
  data = data,
  path = NULL,
  filename = NULL,
  title = NULL,
  subtitle = NULL,
  qr = NULL,
  family.column = NULL,
  taxon.column = NULL,
  author.column = NULL,
  det.column = NULL,
  date.det.column = NULL,
  location.column = NULL,
  area.description.column = NULL,
  latitude.column = NULL,
  longitude.column = NULL,
  elevation.column = NULL,
  field1.column = NULL,
  field2.column = NULL,
  field3.column = NULL,
  collector.column = NULL,
  collection.column = NULL,
  assistants.column = NULL,
  date.column = NULL,
  keep.files = FALSE,
  template = NULL
)
}
\arguments{
\item{data}{a data frame. Each row contains the information by species that will appear in the label.}

\item{path}{Character. Path to folder where the PDF file will be saved.}

\item{filename}{Character. Filename of the pdf. If NULL, default is "Herbarium".}

\item{title}{Main title at the top of the labels. Can be blank if set to NULL.}

\item{subtitle}{Subtitle at the bottom of the labels. Can be blank if set to NULL.}

\item{qr}{String. Free text or column of \code{data} that specifies the link for the QR code.
If the specified value of \code{qr} is not a column name of \code{data},
all the QRs will be equal, pointing to the same link.}

\item{family.column}{Character (optional). Name of the column in \code{data} storing the family of the taxon.}

\item{taxon.column}{Character (optional). Name of the column in \code{data} storing the taxon name.}

\item{author.column}{Character (optional). Name of the column in \code{data} storing the taxon author.}

\item{det.column}{Character (optional). Name of the column in \code{data} storing the determiner of the voucher.}

\item{date.det.column}{Character (optional). Name of the column in \code{data} storing the date when the voucher
was determined.}

\item{location.column}{Character (optional). Name of the column in \code{data} storing where the voucher
was collected.}

\item{area.description.column}{Character (optional). Name of the column in \code{data} storing the description
of the area.}

\item{latitude.column}{Character (optional). Name of the column in \code{data} storing the latitude
where the specimen was collected.}

\item{longitude.column}{Character (optional). Name of the column in \code{data} storing the longitude
where the specimen was collected.}

\item{elevation.column}{Character (optional). Name of the column in \code{data} storing the elevation
where the specimen was collected.}

\item{field1.column}{Character (optional). Name of the column in \code{data} storing the first free text to
appear at the top of the label.}

\item{field2.column}{Character (optional). Name of the column in \code{data} storing the second free text to
appear below field1.}

\item{field3.column}{Character (optional). Name of the column in \code{data} storing the second free text to
appear below field2.}

\item{collector.column}{Character (optional). Name of the column in \code{data} storing the name of the collector.}

\item{collection.column}{Character (optional). Name of the column in \code{data} storing the voucher's collection
number.}

\item{assistants.column}{Character (optional). Name of the column in \code{data} storing the names of the
collector's assistants.}

\item{date.column}{Character (optional). Name of the column in \code{data} storing the date when the specimen
was collected.}

\item{keep.files}{Logical. Keep the RMarkdown template and associated files
in the output folder? Default is FALSE.}

\item{template}{Character (optional) RMarkdown template to use. If not provided,
using the default template included in \code{labeleR}.}
}
\value{
A pdf file with four herbarium labels per page within an 'output' folder.
}
\description{
Create herbarium labels (4 labels per DIN-A4 page)
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

create_herbarium_label (
  data = herbarium.table,
  path = "labeleR_output",
  title = "Magical flora of the British Isles",
  subtitle = "Project: Eliminating plant blindness in Hogwarts students",
  qr = "QR_code",
  family.column ="Family",
  taxon.column = "Taxon",
  author.column = "Author",
  det.column = "det",
  date.det.column = "Det_date",
  location.column = "Location",
  latitude.column = "Latitude",
  longitude.column = "Longitude",
  elevation.column = "Elevation",
  field1.column = "life_form",
  field3.column = "Height",
  collector.column = "Collector",
  collection.column = "Collection_number",
  assistants.column = "Assistants",
  date.column = "Date"
)
\dontshow{\}) # examplesIf}
}
\author{
Ignacio Ramos-Gutierrez, Julia G. de Aledo, Francisco Rodriguez-Sanchez
}
