% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_jpn_rs.R
\name{move_jpn_rs}
\alias{move_jpn_rs}
\title{Clip and move some geometries for mapping}
\usage{
move_jpn_rs(data, clip = TRUE)
}
\arguments{
\item{data}{\link[sf:st_sf]{sf} that records the prefecture or municipality of Japan}

\item{clip}{An option to hide isolated island that are separated from other geometry and have a small area.}
}
\value{
\link[sf:st_sf]{sf}. Geometry in Tokyo may have rows duplicated in Honshu and islands.
}
\description{
Move geometry differently from the real-life arrangement for mapping.
When displaying a map showing Japan, the southern islands are sometimes moved.
To achieve this, we need to perform false operations on the geometry.
}
\examples{
require("sf")
move_jpn_rs(jgd2011_bbox)
}
