% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kpca2D.R
\name{plot_kpca2D}
\alias{plot_kpca2D}
\title{2D Kernel PCA Plot with Variables Representation}
\usage{
plot_kpca2D(kpca_result, target_variable, groups = NULL, scale = 100, 
  components = c(1, 2), arrow_col = "#D3D3D3", 
  main_title = "Kernel principal component analysis")
}
\arguments{
\item{kpca_result}{The result of the previously obtained kernel PCA analysis}

\item{target_variable}{A string indicating the name of the variable of interest to visualize as arrows on the kernel PCA plot.}

\item{groups}{A vector indicating the grouping of data points, if applicable. Default: NULL}

\item{scale}{Coefficient to adjust the lengths of the arrows. Default: 100}

\item{components}{A numeric vector of length 2 specifying the indices of the components to plot. Default: c(1, 2)}

\item{arrow_col}{Colour of the arrows. Default: '#D3D3D3'}

\item{main_title}{Graph title. Default: "Kernel principal component analysis"}

}
\value{
Provides a 2D plot of class ggplot that displays the sample points projected onto the specified kernel principal component axes, with the variables of interest represented as arrows.
}
\description{
\code{plot_kpca2D} allows to visualize an original variable of interest in the specified principal components. The variable is displayed as an arrow, showing its relevance in the relative position of each sample point in the kernel component space.
}
\references{
Briscik, M., Dillies, MA. & Déjean, S. Improvement of variables interpretability in kernel PCA. BMC Bioinformatics 24, 282 (2023). DOI: \doi{doi:10.1186/s12859-023-05404-y}.
Variables representation as in Reverter, F., Vegas, E. & Oller, J.M. Kernel-PCA data integration with enhanced interpretability. BMC Syst Biol 8 (Suppl 2), S6 (2014). DOI: \url{doi:10.1186/1752-0509-8-S2-S6}
}
\examples{
\donttest{
library(WallomicsData)
library(kpcaIG)

Transcriptomics_Stems_s <- scale(Transcriptomics_Stems)

kpca_tan <-  kernelpca(as.matrix(Transcriptomics_Stems_s),
                          kernel = "tanhdot",
                          kpar = list(scale = 0.0001, offset = 0.01))

# Compute the most relevant genes based on the first two components of kpca_tan

kpca_ig_tan <- kpca_igrad(kpca_tan, dim = c(1,2))
head(kpca_ig_tan)

# Visualize the most relevant variable (gene) according to kpca_igrad, "AT4G12060".

plot_kpca2D(kpca_tan, "AT4G12060", groups = Ecotype, scale = 1000, components = c(1, 2))

# Visualize using the second and third components

plot_kpca2D(kpca_tan, "AT4G12060", groups = Ecotype, scale = 1000, components = c(2, 3))

#The selected gene shows upper expression in the samples with genotype type Col.
}
}