% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_correct.R
\docType{methods}
\name{correct.tag}
\alias{correct.tag}
\alias{correct.tag,kRp.text-method}
\title{Methods to correct koRpus objects}
\usage{
correct.tag(
  obj,
  row,
  tag = NULL,
  lemma = NULL,
  check.token = NULL,
  quiet = TRUE
)

\S4method{correct.tag}{kRp.text}(
  obj,
  row,
  tag = NULL,
  lemma = NULL,
  check.token = NULL,
  quiet = TRUE
)
}
\arguments{
\item{obj}{An object of class \code{\link[koRpus:kRp.text-class]{kRp.text}}.}

\item{row}{Integer, the row number of the entry to be changed. Can be an integer vector
to change several rows in one go.}

\item{tag}{A character string with a valid POS tag to replace the current tag entry.
If \code{NULL} (the default) the entry remains unchanged.}

\item{lemma}{A character string naming the lemma to to replace the current lemma entry.
If \code{NULL} (the default) the entry remains unchanged.}

\item{check.token}{A character string naming the token you expect to be in this row.
If not \code{NULL}, \code{correct} will stop with an error if this values don't match.}

\item{quiet}{If \code{FALSE}, messages about all applied changes are shown.}
}
\value{
An object of the same class as \code{obj}.
}
\description{
The method \code{correct.tag} can be used to alter objects of class \code{\link[koRpus:kRp.text-class]{kRp.text}}.
}
\details{
Although automatic POS tagging and lemmatization are remarkably accurate,
      the algorithms do ususally produce
some errors. If you want to correct for these flaws, this method can be of help,
      because it might prevent you from
introducing new errors. That is,
      it will do some sanitiy checks before the object is actually manipulated and returned.

\code{correct.tag} will read the \code{lang} slot from the given object and check whether the \code{tag}
provided is actually valid. If so,
      it will not only change the \code{tag} field in the object, but also update
\code{wclass} and \code{desc} accordingly.

If \code{check.token} is set it must also match \code{token} in the given row(s). Note that no check is done on the lemmata.
}
\examples{
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  sample_file <- file.path(
    path.package("koRpus"), "examples", "corpus", "Reality_Winner.txt"
  )
  tokenized.obj <- tokenize(
    txt=sample_file,
    lang="en"
  )
  tokenized.obj <- correct.tag(tokenized.obj, row=6, tag="NN")
} else {}
}
\seealso{
\code{\link[koRpus:kRp.text-class]{kRp.text}}, \code{\link[koRpus:treetag]{treetag}},
   \code{\link[koRpus:kRp.POS.tags]{kRp.POS.tags}}.
}
\keyword{methods}
