% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_text.transform.R
\docType{methods}
\name{textTransform}
\alias{textTransform}
\alias{textTransform,kRp.taggedText-method}
\title{Letter case transformation}
\usage{
textTransform(txt, scheme, p = 0.5, paste = FALSE)

\S4method{textTransform}{kRp.taggedText}(txt, scheme, p = 0.5,
  paste = FALSE)
}
\arguments{
\item{txt}{An object of class \code{\link[koRpus:kRp.txt.trans-class]{kRp.txt.trans}},
      \code{\link[koRpus:kRp.tagged-class]{kRp.tagged}},
\code{\link[koRpus:kRp.txt.freq-class]{kRp.txt.freq}} or \code{\link[koRpus:kRp.analysis-class]{kRp.analysis}}.}

\item{scheme}{One of the following character strings:
\itemize{
  \item {\code{"minor"}} {Start each word with a lowercase letter.}
  \item {\code{"all.minor"}} {Forces all letters into lowercase.}
  \item {\code{"major"}} {Start each word with a uppercase letter.}
  \item {\code{"all.major"}} {Forces all letters into uppercase.}
  \item {\code{"random"}} {Randomly start words with uppercase or lowercase letters.}
  \item {\code{"de.norm"}} {German norm: All names,
      nouns and sentence beginnings start with an uppercase letter,
     anything else with a lowercase letter.}
  \item {\code{"de.inv"}} {Inversion of \code{"de.norm"}.}
  \item {\code{"eu.norm"}} {Usual European cases: Only names and sentence beginnings start with an uppercase letter,
     anything else with a lowercase letter.}
  \item {\code{"eu.inv"}} {Inversion of \code{"eu.norm"}.}
 }}

\item{p}{Numeric value between 0 and 1. Defines the probability for upper case letters (relevant only
if \code{scheme="random"}).}

\item{paste}{Logical, see value section.}
}
\value{
By default an object of class \code{\link[koRpus:kRp.txt.trans-class]{kRp.txt.trans}} is returned. If \code{paste=TRUE},
      returns
   an atomic character vector (via \code{\link[koRpus:kRp.text.paste]{kRp.text.paste}}).
}
\description{
Transforms text in koRpus objects token by token.
}
\details{
This function is mainly intended to produce text material for experiments.
}
\examples{
\dontrun{
tagged.text.obj <- freq.analysis("/some/text.txt", corp.freq=my.LCC.data)
textTransform(tagged.text.obj, scheme="random", paste=TRUE)
}
}
\keyword{misc}
