% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_show.kRp.lang.R,
%   R/02_method_show.kRp.TTR.R, R/02_method_show.kRp.corp.freq.R,
%   R/02_method_show.kRp.readability.R, R/02_method_show.kRp.taggedText.R
\docType{methods}
\name{show,kRp.lang-method}
\alias{show,kRp.lang-method}
\alias{show,-methods}
\alias{show,kRp.TTR-method}
\alias{show,kRp.corp.freq-method}
\alias{show,kRp.readability-method}
\alias{show,kRp.taggedText-method}
\title{Show methods for koRpus objects}
\usage{
\S4method{show}{kRp.lang}(object)

\S4method{show}{kRp.TTR}(object)

\S4method{show}{kRp.corp.freq}(object)

\S4method{show}{kRp.readability}(object)

\S4method{show}{kRp.taggedText}(object)
}
\arguments{
\item{object}{An object of class \code{kRp.lang}, \code{kRp.readability},
\code{kRp.corp.freq}, or \code{kRp.TTR}.}
}
\description{
Show methods for S4 objects of classes
\code{\link[koRpus:kRp.lang-class]{kRp.lang}},
\code{\link[koRpus:kRp.readability-class]{kRp.readability}},
\code{\link[koRpus:kRp.corp.freq-class]{kRp.corp.freq}} or
\code{\link[koRpus:kRp.TTR-class]{kRp.TTR}}.
}
\examples{
\dontrun{
  guess.lang("/home/user/data/some.txt", udhr.path="/home/user/data/udhr_txt/")
}
\dontrun{
MTLD(tagged.txt)
}
\dontrun{
flesch(tagged.txt)
}
}
\seealso{
\code{\link[koRpus:kRp.lang-class]{kRp.lang}},
   \code{\link[koRpus:kRp.readability-class]{kRp.readability}},
   \code{\link[koRpus:kRp.corp.freq-class]{kRp.corp.freq}},
   \code{\link[koRpus:kRp.TTR-class]{kRp.TTR}}
}
\keyword{methods}
