% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.kRp.env.R
\name{set.kRp.env}
\alias{set.kRp.env}
\title{A function to set information on your koRpus environment}
\usage{
set.kRp.env(..., validate = TRUE)
}
\arguments{
\item{...}{Named parameters to set in the koRpus environment. Valid arguments are:
\describe{
  \item{TT.cmd}{ A character string pointing to the tagger command you want to use for basic text analysis,
      or \code{"manual"} if
     you want to set \code{TT.options} as well. Set to \code{"tokenize"} to use \code{\link[koRpus:tokenize]{tokenize}}.}
  \item{lang}{ A character string specifying a valid language.}
  \item{TT.options}{ A list with arguments to be used as \code{TT.options} by \code{\link[koRpus:treetag]{treetag}}.}
  \item{hyph.cache.file}{ A character string specifying a path to a file to use for storing already hyphenated data,
      used by
     \code{\link[koRpus]{hyphen}}.}
  \item{add.desc}{ A logical value,
      whether tag descriptions should be added directly to tagged text objects.}
}
To explicitly unset a value again, set it to an empty character string (e.g.,
      \code{lang=""}).}

\item{validate}{Logical,
      if \code{TRUE} given paths will be checked for actual availablity, and the function will fail if files can't be found.}
}
\value{
Returns an invisible \code{NULL}.
}
\description{
The function \code{set.kRp.env} can be called before any of the analysing functions. It writes information
on your session environment regarding the koRpus package,
      e.g. path to a local TreeTagger installation,
to your global \code{\link[base:.Options]{.Options}}.
}
\details{
To get the current settings, the function \code{\link[koRpus:get.kRp.env]{get.kRp.env}}
should be used. For the most part, \code{set.kRp.env} is a convenient wrapper for
\code{\link[base:options]{options}}. To permanently set some defaults, you could also add
respective \code{options} calls to an \code{\link[base:.Rprofile]{.Rprofile}} file.

Note that you can also suppress the startup message informing about \code{\link[koRpus:available.koRpus.lang]{available.koRpus.lang}}
and \code{\link[koRpus:install.koRpus.lang]{install.koRpus.lang}} by adding \code{noStartupMessage=TRUE} to the options in \code{.Rprofile}.
}
\examples{
\dontrun{
set.kRp.env(TT.cmd="~/bin/treetagger/cmd/tree-tagger-german", lang="de")
get.kRp.env(TT.cmd=TRUE)

# example for setting permanent default values in an .Rprofile file
options(
  koRpus=list(
    TT.cmd="manual",
    TT.options=list(
      path="~/bin/treetagger",
      preset="de"),
    lang="de",
    noStartupMessage=TRUE
  )
)
# be aware that setting a permamnent default language without loading
# the respective language support package might trigger errors
}
}
\seealso{
\code{\link[koRpus:get.kRp.env]{get.kRp.env}}
}
\keyword{misc}
