% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions_readability.R
\name{nWS}
\alias{nWS}
\title{Readability: Neue Wiener Sachtextformeln}
\usage{
nWS(txt.file, hyphen = NULL, parameters = c(ms.syll = 3, iw.char = 6,
  es.syll = 1), nws1 = c(ms = 19.35, sl = 0.1672, iw = 12.97, es = 3.27, const
  = 0.875), nws2 = c(ms = 20.07, sl = 0.1682, iw = 13.73, const = 2.779),
  nws3 = c(ms = 29.63, sl = 0.1905, const = 1.1144), nws4 = c(ms = 27.44, sl
  = 0.2656, const = 1.693), ...)
}
\arguments{
\item{txt.file}{Either an object of class \code{\link[koRpus]{kRp.tagged-class}},
      a character vector which must be be
a valid path to a file containing the text to be analyzed,
      or a list of text features. If the latter, calculation
is done by \code{\link[koRpus:readability.num]{readability.num}}.}

\item{hyphen}{An object of class kRp.hyphen. If \code{NULL},
      the text will be hyphenated automatically.}

\item{parameters}{A numeric vector with named magic numbers,
      defining the relevant parameters for all formulas of the index.}

\item{nws1}{A numeric vector with named magic numbers for the first of the formulas.}

\item{nws2}{A numeric vector with named magic numbers for the second of the formulas.}

\item{nws3}{A numeric vector with named magic numbers for the third of the formulas.}

\item{nws4}{A numeric vector with named magic numbers for the fourth of the formulas.}

\item{...}{Further valid options for the main function,
      see \code{\link[koRpus:readability]{readability}} for details.}
}
\value{
An object of class \code{\link[koRpus]{kRp.readability-class}}.
}
\description{
This is just a convenient wrapper function for \code{\link[koRpus:readability]{readability}}.
}
\details{
This function calculates the new Wiener Sachtextformeln (formulas 1 to 4). In contrast to \code{\link[koRpus:readability]{readability}},
which by default calculates all possible indices,
      this function will only calculate the index values.
}
\examples{
\dontrun{
nWS(tagged.text)
}
}
\references{
Bamberger, R. & Vanecek,
      E. (1984). \emph{Lesen--Verstehen--Lernen--Schreiben}. Wien: Jugend und Volk.
}
\keyword{readability}
