% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_cv.r
\name{kms_cv}
\alias{kms_cv}
\title{K-Means Based Cross-Validation}
\usage{
kms_cv(data, k = 5, centers = NULL, max_center = 20, alpha = 0.1, seed = NULL)
}
\arguments{
\item{data}{A data frame or data structure that can be converted to a data frame.}

\item{k}{The number of partitions of the data set.}

\item{centers}{Number of clusters to be created. If \code{NULL}, centers are selected automatically based on scaled inertia.}

\item{max_center}{If \code{centers} is \code{NULL} number of clusters to be tried.}

\item{alpha}{Alpha coefficient to penalize inertias.}

\item{seed}{Seed number to reproduce randomness.}
}
\value{
A tibble with classes \code{manual_rset}, \code{rset}, \code{tbl_df}, \code{tbl}, and
\code{data.frame}. The results include a column for the data split objects and
one or more identification variables. There is a column called \code{id} that has
a character string with the fold identifier.
}
\description{
K-Means based cross-validation splits data into clusters and creates random
splits the data into K groups of roughly equal proportions (called "folds") as the main data.
}
\examples{
library(kmscv)

kms_cv(iris,k = 5,centers = NULL,max_center = 20,alpha = .1,seed = 1)

}
