% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_kindist_simple.R
\name{simulate_kindist_simple}
\alias{simulate_kindist_simple}
\title{Simulate kin dispersal distance pairs with simple sigma}
\usage{
simulate_kindist_simple(
  nsims = 100,
  sigma = 125,
  dims = 100,
  method = "Gaussian",
  kinship = "PO",
  lifestage = "immature",
  shape = 0.5
)
}
\arguments{
\item{nsims}{(integer) -   number of pairs to simulate}

\item{sigma}{(numeric) -   size of simple (axial) sigma}

\item{dims}{(numeric) -   length of sides of (square) simulated site area}

\item{method}{(character) - kernel shape to use: either 'Gaussian', 'Laplace' or 'vgamma' (variance-gamma)}

\item{kinship}{(character)- kin category to simulate: one of PO, FS, HS, AV, GG, HAV, GGG, 1C, 1C1, 2C, GAV, HGAV, H1C or H2C}

\item{lifestage}{(lifestage) lifestage at sample collection: either 'immature' or 'ovipositional'}

\item{shape}{(numeric) value of shape parameter to use with 'vgamma' method. Default 0.5}
}
\value{
\preformatted{ returns an object of class \code{KinPairSimulation} containing simulation details and a \code{tibble} (tab) of simulation values
}
}
\description{
Simulate kin dispersal distance pairs with simple sigma
}
\examples{
test <- simulate_kindist_simple(nsims = 10, sigma = 50, dims = 1000, method = "Laplace")
simulate_kindist_simple(nsims = 10000, sigma = 75, kinship = "PO", lifestage = "ovipositional")
}
