% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axial_helper_functions.R
\name{axpermute}
\alias{axpermute}
\title{Estimate the axial dispersal distance of a kernel with confidence intervals}
\usage{
axpermute(vals, nreps = 1000, nsamp = "std", composite = 1, output = "confs")
}
\arguments{
\item{vals}{numeric. Vector of distances between close kin OR object of class KinPairData.}

\item{nreps}{numeric. Number of permutations to run for confidence intervals (default 1000)}

\item{nsamp}{numeric. Number of kin pairs to subsample for each permutation.
Either "std" or an integer. If "std" will be computed as equal to the sample size. (default "std")}

\item{composite}{numeric. The number of separate 'draws' (dispersal events)
from the kernel required to produce the final positions of the measured individuals.
For example, the displacement of a child from parent at the same lifestage would involve 1 draw and thus be composite = 1.
Two full siblings would be two draws (composite = 2) from the FS kernel. Non-symmetric relationships (e.g. AV, 1C)
should not be decomposed using this method, nor should any assumptions be made about different kernels
(e.g. the 1C relationship would appropriately be given the value 2, but not 4)}

\item{output}{character. Denotes what kind of output to return.
If 'confs', a vector of 95\% confidence intervals. if 'vect', a vector of all permuted axial value results}
}
\value{
If ouput = 'confs', returns a \code{numeric vector} of 95\% confidence intervals and mean axial value.
if output = 'vect', returns a \code{numeric vector} of all permuted axial value results
}
\description{
Estimate the axial dispersal distance of a kernel with confidence intervals
}
\examples{
po_dists <- rexp(100, 1 / 50)
axpermute(po_dists, composite = 1)
}
