% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairData.R
\name{distances,KinPairData-method}
\alias{distances,KinPairData-method}
\alias{kinship,KinPairData-method}
\alias{kinship<-,KinPairData-method}
\alias{lifestage,KinPairData-method}
\alias{lifestage<-,KinPairData-method}
\alias{show,KinPairData-method}
\alias{initialize,KinPairData-method}
\title{Constructor method for \code{KinPairData} objects.}
\usage{
\S4method{distances}{KinPairData}(x)

\S4method{kinship}{KinPairData}(x)

\S4method{kinship}{KinPairData}(x) <- value

\S4method{lifestage}{KinPairData}(x)

\S4method{lifestage}{KinPairData}(x) <- value

\S4method{show}{KinPairData}(object)

\S4method{initialize}{KinPairData}(.Object, data = NULL, kinship = NULL, lifestage = NULL, ...)
}
\arguments{
\item{x}{object of class \code{KinPairData}}

\item{value}{value to assign to slot}

\item{object}{an object of class KinpairData}

\item{.Object}{the KinPairData object to be constructed}

\item{data}{data about kinship to be used to construct object (tibble, data.frame, or numeric vector of distances)}

\item{kinship}{character. Kinship category value for object. - one of PO, FS, HS, AV, HAV, GG, 1C, H1C, GAV, HGAV, 1C1, H1C1, GGG, 2C, and H2C.}

\item{lifestage}{character. Lifestage value for object. - one of 'immature', 'ovipositional' or 'unknown'}

\item{...}{additional argument to pass to downstream functions in future}

\item{KinPairData}{object of class KinPairData}
}
\value{
numeric vector of kin separation distances

\code{character} kinship of \code{KinPairData} object

modified object of class \code{KinPairData}

\code{character} lifestage of \code{KinPairData} object

modified object of class \code{KinPairData}

No return value, called for side effects

Returns an object of class \code{KinPairData}
}
\description{
Constructor method for \code{KinPairData} objects.
}
\section{Methods (by generic)}{
\itemize{
\item \code{distances}: access distances

\item \code{kinship}: access kin category

\item \code{kinship<-}: assign kin category

\item \code{lifestage}: access lifestage

\item \code{lifestage<-}: assign lifestage

\item \code{show}: standard print method

\item \code{initialize}: initialize method
}}

