% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2-tol.R
\name{scale_tol_sequential}
\alias{scale_tol_sequential}
\alias{scale_colour_YlOrBr}
\alias{scale_color_YlOrBr}
\alias{scale_fill_YlOrBr}
\alias{scale_colour_smoothrainbow}
\alias{scale_color_smoothrainbow}
\alias{scale_fill_smoothrainbow}
\title{Paul Tol's sequential colour schemes for ggplot2}
\usage{
scale_colour_YlOrBr(..., reverse = FALSE, aesthetics = "colour")

scale_color_YlOrBr(..., reverse = FALSE, aesthetics = "colour")

scale_fill_YlOrBr(..., reverse = FALSE, aesthetics = "fill")

scale_colour_smoothrainbow(..., reverse = FALSE, aesthetics = "colour")

scale_color_smoothrainbow(..., reverse = FALSE, aesthetics = "colour")

scale_fill_smoothrainbow(..., reverse = FALSE, aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2]{continuous_scale}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colours be reversed?}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\description{
Provides sequential colour scales from Paul Tol's \emph{Colour Schemes}.
}
\details{
Sequential colour schemes are linearly interpolated.
 \tabular{ll}{
  \strong{Palette} \tab \strong{Max.} \cr
  YlOrBr \tab 9 \cr
  smooth rainbow \tab 34
 }
}
\examples{
library("ggplot2")

# Sequential data
ggplot(faithfuld, aes(waiting, eruptions, fill = density)) +
  geom_raster() +
  scale_fill_YlOrBr()

ggplot(faithfuld, aes(waiting, eruptions, fill = density)) +
  geom_raster() +
  scale_fill_smoothrainbow(reverse = TRUE)
}
\references{
Tol, Paul (2018). \emph{Colour Schemes.} SRON. Technical Note No.
 SRON/EPS/TN/09-002. URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other Paul Tol's colour schemes: \code{\link{scale_tol_discrete}},
  \code{\link{scale_tol_diverging}}
}
\author{
N. Frerebeau
}
\concept{Paul Tol's colour schemes}
