% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_analytics.R
\name{get_analytics}
\alias{get_analytics}
\title{Retrieves Analytics Table Data from KHIS}
\usage{
get_analytics(
  ...,
  return_type = c("uid", "name"),
  retry = 2,
  verbosity = 0,
  timeout = 60
)
}
\arguments{
\item{...}{One or more \code{\link[=analytics_dimension]{analytics_dimension()}} in key-value pairs.}

\item{return_type}{The type to be return names of uid.}

\item{retry}{Number of times to retry the API call in case of failure
(defaults to 2).}

\item{verbosity}{Level of HTTP information to print during the call:
\itemize{
\item 0: No output
\item 1: Show headers
\item 2: Show headers and bodies
\item 3: Show headers, bodies, and CURL status message.
}}

\item{timeout}{Maximum number of seconds to wait for the API response.}
}
\value{
A tibble with detailed information
}
\description{
\code{get_analytics()} fetches data from the KHIS analytics data tables for a
given period and data element(s), without performing any aggregation.
}
\details{
\itemize{
\item Retrieves data directly from KHIS analytics tables.
\item Allows specifying KHIS session objects, retry attempts, and logging verbosity.
}
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Clinical Breast Examination data elements
# XEX93uLsAm2 = CBE Abnormal
# cXe64Yk0QMY = CBE Normal
element_id = c('cXe64Yk0QMY', 'XEX93uLsAm2')

# Download data from February 2023 to current date
data <- get_analytics(dx \%.d\% element_id, pe \%.d\% 'LAST_MONTH')
data
\dontshow{\}) # examplesIf}
}
