% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_encodes.R
\name{sparse_encode}
\alias{sparse_encode}
\title{sparse_encode}
\usage{
sparse_encode(
  m_data,
  dist_method = "norm_inprod",
  encoding = c("epsilon", "hard", "soft"),
  sigma,
  n_neighbors = floor(nrow(m_data)/10),
  scale_obs = TRUE
)
}
\arguments{
\item{m_data}{Numeric matrix}

\item{dist_method}{Distance method passed to qb_dist}

\item{encoding}{Encoding method: one of hard, soft, or epsilon}

\item{sigma}{Parameter for the exponential norm transform.
Default is mean of std. dev. of distance matrix columns}

\item{n_neighbors}{Number of neighbors (ignored in epsilon encoding)}

\item{scale_obs}{Scale by observations}
}
\value{
Projected matrix
}
\description{
Sparse encoding method by closest neighbors. 
Three methods are available:
  - hard encoding: each patient's closest neighbors are set to 1, others
    are set to 0
  - soft encoding: each patient's closest neighbors distances are
    transformed by the exponential norm, others are set to 0
  - epsilon encoding: each patient's neighbors closer than the mean of
    the distance matrix are transformed by the exponential norm and
    others are set to 0.
}
