% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/special_tokens.R
\name{EOS}
\alias{EOS}
\alias{BOS}
\alias{UNK}
\alias{special_tokens}
\title{Special Tokens}
\usage{
EOS()

BOS()

UNK()
}
\value{
a string representing the appropriate special token.
}
\description{
Return Begin-Of-Sentence, End-Of-Sentence and Unknown-Word special tokens.
}
\details{
These functions return the internal representation of BOS, EOS and UNK tokens
respectively. Their actual returned values are irrelevant and their only
purpose is to simplify queries of k-gram counts and probabilities involving
the special tokens, as shown in the examples.
}
\examples{
f <- kgram_freqs("a b b a b", 2)
query(f, c(BOS(), EOS(), UNK()))
probability(c("a", "b") \%|\% BOS(), f)
probability("a b b a" \%+\% EOS(), f)

# The actual values of BOS(), EOS() and UNK() are irrelevant
c(BOS(), EOS(), UNK())


}
\author{
Valerio Gherardi
}
