% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{calc_Ks}
\alias{calc_Ks}
\title{Calculate equilibrium constants for seawater}
\usage{
calc_Ks(
  ks = NULL,
  temp_c = 25,
  sal = 35,
  p_bar = NULL,
  magnesium = 0.0528171,
  calcium = 0.0102821,
  sulphate = NULL,
  fluorine = NULL,
  method = "MyAMI"
)
}
\arguments{
\item{ks}{character vectors of Ks to be calculated e.g., c("K0", "K1")}

\item{temp_c}{Temperature (Celsius)}

\item{sal}{Salinity}

\item{p_bar}{Pressure (Bar) (optional)}

\item{magnesium}{Magnesium concentration in mol/kgsw. If None, modern is assumed (0.0528171). Should be the average magnesium concentration in seawater - a salinity correction is then applied to calculate the magnesium concentration in the sample.}

\item{calcium}{Calcium concentration in mol/kgsw. If None, modern is assumed (0.0102821). Should be the average calcium concentration in seawater - a salinity correction is then applied to calculate the magnesium concentration in the sample.}

\item{sulphate}{Sulphate concentration in mol/kgsw. Calculated from salinity if not given.}

\item{fluorine}{Fluorine concentration in mol/kgsw. Calculated from salinity if not given.}

\item{method}{Options: \code{R_Polynomial}, \code{MyAMI_Polynomial} , \code{MyAMI} (defaults to "MyAMI").}
}
\value{
Data.table of specified Ks at the given conditions
}
\description{
Wrapper to calculate multiple stoichiometric equilibrium constants at given temperature, salinity, pressure and the concentration of magnesium, calcium, sulphate, and fluorine.
}
\author{
Dennis Mayk
}
