% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{group.mreach.degree}
\alias{group.mreach.degree}
\title{Compute the group-level mreach.degree Centrality Score in a Netwrok}
\usage{
group.mreach.degree(adj.matrix, nodes, M = Inf, method = "min",
  binary = TRUE, cmode = "total")
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{nodes}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. If there are multiple players,
use \code{c(index1,index2,...)}}

\item{M}{Number indicating the maximum distance between two nodes,
above which the two nodes are considered disconnected.
m hence defines a reachable set. The default is \code{Inf}.}

\item{method}{Indication of which grouping criterion should be used.
\code{method="min"} indicates the "minimum" criterion (edge values as distances).
\code{method="max"} indicates the "maximum" criterion (edge values as non-cummulative strengths).
\code{method="add"} indicates the "addition" criterion (edge values as cummulative strengths).
\code{method="union"} indicates the "union" criterion (edge values as probability).
The default is the "minimum" criterion for mreach.degree centrality.}

\item{binary}{If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered.}

\item{cmode}{String indicating the type of centrality being evaluated.
The default is to report the total degree.
\code{"outdegree"} and \code{"indegree"} refer to indegree and outdegree
respectively. If \code{"all"}, all the three types are reported.}
}
\value{
A vector indicating the outdegree, indegree, or total-degree
mreach.degree score of the chosen player(s); or a data frame containing all
the above information.
}
\description{
\code{group.mreach.degree} computes the size of the reachable set within M.
}
\author{
Weihua An \email{weihuaan@indiana.edu}; Yu-Hsin Liu \email{yuhsliu@indiana.edu}
}
\keyword{internal}

