% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{desparsify}
\alias{desparsify}
\title{This function deletes those columns and/or rows in a matrix/data.frame that
only contain 0s.}
\usage{
desparsify(X, dim = 2)
}
\arguments{
\item{X}{Numeric matrix or data.frame of any size.}

\item{dim}{A numeric vector. 1 indicates that the function should be applied
to rows, 2 to columns, c(1, 2) indicates rows and columns. (Defaults: 2).}
}
\value{
X with less rows or columns. (Class: the same than X).
}
\description{
This function deletes those columns and/or rows in a matrix/data.frame that
only contain 0s.
}
\examples{
dat <- matrix(rnorm(150),ncol=50,nrow=30)
dat[c(2,6,12),] <- 0
dat[,c(30,40,50)] <- 0
dim(desparsify(dat))
dim(desparsify(dat,dim=c(1,2)))
}
