% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config_enable_traceback_filtering}
\alias{config_enable_traceback_filtering}
\title{Turn on traceback filtering.}
\usage{
config_enable_traceback_filtering()
}
\value{
No return value, called for side effects.
}
\description{
Raw Keras tracebacks (also known as stack traces)
involve many internal frames, which can be
challenging to read through, while not being actionable for end users.
By default, Keras filters internal frames in most exceptions that it
raises, to keep traceback short, readable, and focused on what's
actionable for you (your own code).

See also \code{\link[=config_disable_traceback_filtering]{config_disable_traceback_filtering()}} and
\code{\link[=config_is_traceback_filtering_enabled]{config_is_traceback_filtering_enabled()}}.

If you have previously disabled traceback filtering via
\code{\link[=config_disable_traceback_filtering]{config_disable_traceback_filtering()}}, you can re-enable it via
\code{\link[=config_enable_traceback_filtering]{config_enable_traceback_filtering()}}.
}
\seealso{
Other traceback utils: \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pack_x_y_sample_weight}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{unpack_x_y_sample_weight}()} \cr
\code{\link{zip_lists}()} \cr

Other config: \cr
\code{\link{config_backend}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_unsafe_deserialization}()} \cr
\code{\link{config_epsilon}()} \cr
\code{\link{config_floatx}()} \cr
\code{\link{config_image_data_format}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{config_set_backend}()} \cr
\code{\link{config_set_epsilon}()} \cr
\code{\link{config_set_floatx}()} \cr
\code{\link{config_set_image_data_format}()} \cr
}
\concept{config}
\concept{traceback utils}
\concept{utils}
