% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-wrappers.R
\name{bidirectional}
\alias{bidirectional}
\title{Bidirectional wrapper for RNNs}
\usage{
bidirectional(
  object,
  layer,
  merge_mode = "concat",
  weights = NULL,
  backward_layer = NULL,
  ...
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{layer}{A \code{RNN} layer instance, such as \code{layer_lstm()} or
\code{layer_gru()}. It could also be a \code{keras$layers$Layer} instance that
meets the following criteria:
\enumerate{
\item Be a sequence-processing layer (accepts 3D+ inputs).
\item Have a \code{go_backwards}, \code{return_sequences} and \code{return_state} attribute
(with the same semantics as for the \code{RNN} class).
\item Have an \code{input_spec} attribute.
\item Implement serialization via \code{get_config()} and \code{from_config()}. Note
that the recommended way to create new RNN layers is to write a custom RNN
cell and use it with \code{layer_rnn()}, instead of subclassing
\code{keras$layers$Layer} directly.
\item When \code{returns_sequences = TRUE}, the output of the masked timestep will
be zero regardless of the layer's original \code{zero_output_for_mask} value.
}}

\item{merge_mode}{Mode by which outputs of the forward and backward RNNs will
be combined. One of \code{'sum'}, \code{'mul'}, \code{'concat'}, \code{'ave'}, \code{NULL}. If
\code{NULL}, the outputs will not be combined, they will be returned as a list.
Default value is \code{'concat'}.}

\item{weights}{Split and propagated to the \code{initial_weights} attribute on the
forward and backward layer.}

\item{backward_layer}{Optional \code{keras.layers.RNN}, or \code{keras.layers.Layer}
instance to be used to handle backwards input processing. If
\code{backward_layer} is not provided, the layer instance passed as the \code{layer}
argument will be used to generate the backward layer automatically. Note
that the provided \code{backward_layer} layer should have properties matching
those of the \code{layer} argument, in particular it should have the same values
for \code{stateful}, \code{return_states}, \code{return_sequences}, etc. In addition,
\code{backward_layer} and \code{layer} should have different \code{go_backwards} argument
values. A \code{ValueError} will be raised if these requirements are not met.}

\item{...}{standard layer arguments.}
}
\description{
Bidirectional wrapper for RNNs
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Bidirectional}
\item \url{https://keras.io/api/layers/recurrent_layers/bidirectional/}
}

Other layer wrappers: 
\code{\link{time_distributed}()}
}
\concept{layer wrappers}
