% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{save_text_tokenizer}
\alias{save_text_tokenizer}
\alias{load_text_tokenizer}
\title{Save a text tokenizer to an external file}
\usage{
save_text_tokenizer(object, filename)

load_text_tokenizer(filename)
}
\arguments{
\item{object}{Text tokenizer fit with \code{\link[=fit_text_tokenizer]{fit_text_tokenizer()}}}

\item{filename}{File to save/load}
}
\description{
Enables persistence of text tokenizers alongside saved models.
}
\details{
You should always use the same text tokenizer for training and
prediction. In many cases however prediction will occur in another
session with a version of the model loaded via \code{\link[=load_model_hdf5]{load_model_hdf5()}}.

In this case you need to save the text tokenizer object after training
and then reload it prior to prediction.
}
\examples{
\dontrun{

# vectorize texts then save for use in prediction
tokenizer <- text_tokenizer(num_words = 10000) \%>\%
fit_text_tokenizer(tokenizer, texts)
save_text_tokenizer(tokenizer, "tokenizer")

# (train model, etc.)

# ...later in another session
tokenizer <- load_text_tokenizer("tokenizer")

# (use tokenizer to preprocess data for prediction)

}

}
\seealso{
Other text tokenization: 
\code{\link{fit_text_tokenizer}()},
\code{\link{sequences_to_matrix}()},
\code{\link{text_tokenizer}()},
\code{\link{texts_to_matrix}()},
\code{\link{texts_to_sequences_generator}()},
\code{\link{texts_to_sequences}()}
}
\concept{text tokenization}
