% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-custom.R
\name{create_layer_wrapper}
\alias{create_layer_wrapper}
\title{Create a Keras Layer wrapper}
\usage{
create_layer_wrapper(Layer, modifiers = NULL, convert = TRUE)
}
\arguments{
\item{Layer}{A R6 or Python class generator that inherits from
\code{keras$layers$Layer}}

\item{modifiers}{A named list of functions to modify to user-supplied
arguments before they are passed on to the class constructor. (e.g.,
\code{list(units = as.integer)})}

\item{convert}{Boolean, whether the Python class and its methods should by
default convert python objects to R objects.

See guide 'making_new_layers_and_models_via_subclassing.Rmd' for example usage.}
}
\value{
An R function that behaves similarly to the builtin keras \verb{layer_*}
functions. When called, it will create the class instance, and also
optionally call it on a supplied argument \code{object} if it is present. This
enables keras layers to compose nicely with the pipe (\verb{\%>\%}).

The R function will arguments taken from the \code{initialize} (or \verb{__init__})
method of the Layer.

If Layer is an R6 object, this will delay initializing the python
session, so it is safe to use in an R package.
}
\description{
Create a Keras Layer wrapper
}
